<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRealtiesTable extends Migration {

	public function up()
	{
		Schema::create('realties', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('realty_type');
			$table->string('name')->nullable();
			$table->integer('realty_num')->nullable();
			$table->double('space')->nullable();
			$table->integer('floor_count');
			$table->enum('one_block', array('yes', 'no', ''))->nullable();
			$table->integer('unit_count')->nullable();
			$table->string('electricity_account')->nullable();
			$table->string('water_account')->nullable();
			$table->enum('one_water_account', array('yes', 'no', ''))->nullable();
			$table->integer('land_license')->nullable();
			$table->double('land_space')->nullable();
			$table->double('land_value')->nullable();
			$table->string('city')->nullable();
			$table->string('district')->nullable();
			$table->string('street')->nullable();
			$table->string('building_number')->nullable();
			$table->string('postcode')->nullable();
			$table->string('additional_number')->nullable();
			$table->string('longitude')->nullable();
			$table->string('latitude')->nullable();
			$table->enum('in_charge', array('yes', 'no'))->nullable();
			$table->string('responsible_name')->nullable();
			$table->string('responsible_phone')->nullable();
			$table->enum('guard_is_responsible', array('yes', 'no', ''))->nullable();
			$table->enum('guard_in_charge', array('yes', 'no', ''))->nullable();
			$table->string('guard_name')->nullable();
			$table->string('guard_phone')->nullable();
			$table->enum('has_parking', array('yes', 'no', ''))->nullable();
			$table->integer('parking_num')->nullable();
			$table->enum('is_elevator_here', array('yes', 'no', ''))->nullable();
			$table->integer('elevator_count')->nullable();
			$table->integer('user_id');
			$table->enum('has_watchman', array('yes', 'no'))->nullable();
		});
	}

	public function down()
	{
		Schema::drop('realties');
	}
}