<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Bills extends Eloquent {

	protected $table = 'bills';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('realty_id', 'unit_id', 'serial_num', 'bill_status', 'date', 'value', 'user_id', 'due_days');

	public function realty()
	{
		return $this->belongsTo('Realties', 'realty_id');
	}

	public function user()
	{
		return $this->belongsTo('Users', 'user_id');
	}

	public function unit()
	{
		return $this->belongsTo('Units', 'unit_id');
	}

	public function payments()
	{
		return $this->hasMany('Payments', 'bill_id');
	}

	public function billstatus()
	{
		return $this->belongsTo('Presets', 'bill_status');
	}

}