<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Discounts extends Eloquent {

	protected $table = 'discounts';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'code', 'value', 'type', 'period', 'repeat', 'max_uses', 'uses');

	public function packages()
	{
		return $this->hasMany('Packages', 'discount_id');
	}

}