<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Expenses extends Eloquent {

	protected $table = 'expenses';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('realty_id', 'unit_id', 'provider_id', 'date', 'bill_num', 'total', 'exchange_id', 'description', 'serial', 'user_id');

	public function realty()
	{
		return $this->belongsTo('Realties', 'realty_id');
	}

	public function unit()
	{
		return $this->belongsTo('Units', 'unit_id');
	}

	public function exchange()
	{
		return $this->belongsTo('Exchanges', 'exchange_id');
	}

	public function provider()
	{
		return $this->belongsTo('Providers', 'provider_id');
	}

	public function user()
	{
		return $this->belongsTo('Users', 'user_id');
	}

}