<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Orders extends Eloquent {

	protected $table = 'orders';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('user_id', 'pakage_id', 'due_date', 'upgrade_date', 'expire_date', 'discount_id', 'discount_count', 'total', 'status', 'max_units');

	public function user()
	{
		return $this->belongsTo('Users', 'user_id');
	}

	public function package()
	{
		return $this->belongsTo('Packages', 'package_id');
	}

	public function discount()
	{
		return $this->belongsTo('Discounts', 'discount_id');
	}

}