<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Requests extends Eloquent {

	protected $table = 'requests';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('realty_id', 'unit_id', 'provider_id', 'request_status', 'details', 'date', 'user_id');

	public function realty()
	{
		return $this->belongsTo('Realties', 'realty_id');
	}

	public function unit()
	{
		return $this->belongsTo('Units', 'unit_id');
	}

	public function provider()
	{
		return $this->belongsTo('Providers', 'provider_id');
	}

	public function user()
	{
		return $this->belongsTo('Users', 'user_id');
	}

	public function requeststatus()
	{
		return $this->belongsTo('Presets', 'request_status');
	}

}