<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Discounts extends Model 
{

    protected $table = 'discounts';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'code', 'value', 'type', 'period', 'repeat', 'max_uses', 'uses');

    public function packages()
    {
        return $this->hasMany('Packages', 'discount_id');
    }

}