<?php

namespace App/Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class City extends Eloquent {

	protected $table = 'cities';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function offers()
	{
		return $this->hasMany('City', 'city_id');
	}

	public function companies()
	{
		return $this->hasMany('City');
	}

}