<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTransactionsTable extends Migration {

	public function up()
	{
		Schema::create('transactions', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->mediumInteger('amount');
			$table->string('method');
			$table->integer('user_id')->unsigned();
			$table->string('wepay_transaction_id');
		});
	}

	public function down()
	{
		Schema::drop('transactions');
	}
}