<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Rally extends Eloquent {

	protected $table = 'rallies';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function owners()
	{
		return $this->hasMany('User', 'owner_rally', 'rally_id', 'user_id');
	}

	public function followers()
	{
		return $this->hasMany('User', 'rally_user', 'rally_id', 'user_id');
	}

	public function parent()
	{
		return $this->belongsTo('Campaign');
	}

}