<?php

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	public function ralliesOwned()
	{
		return $this->belongsToMany('Rally', 'owner_rally', 'user_id', 'rally_id');
	}

	public function rallies()
	{
		return $this->belongsToMany('Rally', 'rally_user', 'user_id', 'rally_id');
	}

	public function userRole()
	{
		return $this->hasOne('Role');
	}

	public function campaigns()
	{
		return $this->hasMany('Campaign', 'owner_id');
	}

	public function followedCampaigns()
	{
		return $this->belongsToMany('Campaign', 'campaign_user', 'user_id', 'campaign_id');
	}

	public function transactionsPerUser()
	{
		return $this->hasMany('Transaction');
	}

}