<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFormSubmissionsTable extends Migration {

	public function up()
	{
		Schema::create('form_submissions', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('form_id')->unsigned();
			$table->bigInteger('workflow_id')->unsigned();
			$table->enum('status', array('pending', 'approved', 'rejected'));
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('form_submissions');
	}
}