<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateStepsTable extends Migration {

	public function up()
	{
		Schema::create('steps', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->string('description');
			$table->bigInteger('workflow_id')->unsigned();
			$table->bigInteger('condition_id')->unsigned();
			$table->bigInteger('assigned_to')->unsigned();
			$table->integer('order');
			$table->enum('type', array('decision', 'task', 'API_call', 'form'));
			$table->enum('status', array('pending', 'completed', 'review'));
			$table->date('due_date');
			$table->date('completion_date');
			$table->string('attachments');
			$table->string('notes');
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('steps');
	}
}