<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateWorkflowsTable extends Migration {

	public function up()
	{
		Schema::create('workflows', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->string('description');
			$table->bigInteger('user_id')->unsigned();
			$table->enum('status', array('active', 'inactive', 'pending', 'completed'));
			$table->enum('visibility', array('public', 'private'));
			$table->date('start_date');
			$table->date('end_date');
			$table->enum('priority', array('low', 'medium', 'high'));
			$table->integer('version');
			$table->bigInteger('approved_by')->unsigned();
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('workflows');
	}
}