<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Point extends Model 
{

    protected $table = 'points';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('user_id', 'points', 'date');
    protected $visible = array('user_id', 'points', 'date');

    public function user()
    {
        return $this->belongsTo('App\User');
    }

}