<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('user_category', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('user_category', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('points', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('no action')
						->onUpdate('no action');
		});
	}

	public function down()
	{
		Schema::table('user_category', function(Blueprint $table) {
			$table->dropForeign('user_category_user_id_foreign');
		});
		Schema::table('user_category', function(Blueprint $table) {
			$table->dropForeign('user_category_category_id_foreign');
		});
		Schema::table('points', function(Blueprint $table) {
			$table->dropForeign('points_user_id_foreign');
		});
	}
}