<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Point extends Eloquent {

	protected $table = 'points';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('user_id', 'points', 'date');
	protected $visible = array('user_id', 'points', 'date');

	public function user()
	{
		return $this->belongsTo('App\User');
	}

}