<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('username', 'password', 'role');
	protected $visible = array('username', 'password', 'role');

	public function categories()
	{
		return $this->belongsToMany('App\Category')->withPivot('points')->withTimestamps();
	}

	public function points()
	{
		return $this->hasMany('App\Point');
	}

}