<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEventsTable extends Migration {

	public function up()
	{
		Schema::create('events', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->string('name');
			$table->date('date');
			$table->text('location');
			$table->time('start_time');
			$table->time('end_time');
			$table->text('description');
			$table->bigInteger('user_id')->unsigned();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('events');
	}
}