<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRequestServiceTable extends Migration {

	public function up()
	{
		Schema::create('request_service', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->timestamps();
			$table->bigInteger('user_id')->unsigned();
			$table->bigInteger('service_id')->unsigned();
			$table->enum('status', array('pending', 'new', 'done'));
		});
	}

	public function down()
	{
		Schema::drop('request_service');
	}
}