<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateStaffTable extends Migration {

	public function up()
	{
		Schema::create('staff', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 255)->nullable();
			$table->string('sur_name', 255)->nullable();
			$table->string('perfect_name', 255)->nullable();
			$table->integer('gender')->nullable();
			$table->date('dob')->nullable();
			$table->text('image')->nullable();
			$table->integer('category_id')->nullable();
			$table->integer('title_id')->nullable();
			$table->string('phone_number', 255)->nullable();
			$table->string('er_contact_name', 255)->nullable();
			$table->string('er_contact_relation', 255)->nullable();
			$table->string('er_contact_phone', 255)->nullable();
			$table->text('street_name')->nullable();
			$table->text('street_number')->nullable();
			$table->text('sub_urban')->nullable();
			$table->integer('state_id')->nullable();
			$table->string('pincode', 255)->nullable();
			$table->integer('location_id')->nullable();
			$table->integer('work_location_id')->nullable();
			$table->tinyInteger('in_work')->nullable();
			$table->tinyInteger('is_active')->nullable()->default('1');
			$table->tinyInteger('is_approved')->nullable()->default('0');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('staff');
	}
}