<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class ServiceCategory extends Eloquent {

	protected $table = 'service_category';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'description', 'image', 'is_active', 'created_by');

	public function jobTitle()
	{
		return $this->hasMany('JobTitle', 'category_id', 'id');
	}

}