<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Client extends Model 
{

    protected $table = 'client';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('company_id', 'name', 'email', 'land_phone', 'position', 'is_active', 'is_approved');

    public function getState()
    {
        return $this->hasOne('Provinces', 'state_id', 'id');
    }

    public function getLocation()
    {
        return $this->hasOne('Location', 'company_location', 'id');
    }

    public function getCompany()
    {
        return $this->hasOne('ClientManager', 'company_id', 'id');
    }

}