<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Staff extends Model 
{

    protected $table = 'staff';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'sur_name', 'perfect_name', 'gender', 'dob', 'image', 'category_id', 'title_id', 'phone_number', 'er_contact_name', 'er_contact_relation', 'er_contact_phone', 'street_name', 'street_number', 'sub_urban', 'state_id', 'pincode', 'location_id', 'work_location_id', 'in_work', 'is_active', 'is_approved');

    public function documents()
    {
        return $this->hasMany('StaffDocument', 'staff_id', 'id');
    }

    public function getState()
    {
        return $this->hasOne('Provinces', 'id', 'state_id');
    }

    public function getLocation()
    {
        return $this->hasOne('Location', 'location', 'work_location', 'id');
    }

    public function getAvailability()
    {
        return $this->hasMany('StaffAvailability', 'id', 'staff_id');
    }

}