<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSettingsTable extends Migration {

	public function up()
	{
		Schema::create('settings', function(Blueprint $table) {
			$table->increments('id');
			$table->string('panel_name', 255)->nullable();
			$table->string('panel_mail', 255)->nullable();
			$table->string('panel_number')->nullable();
			$table->longText('about_us')->nullable();
			$table->longText('privacy_policy')->nullable();
			$table->longText('terms_condition')->nullable();
			$table->tinyInteger('is_active')->nullable()->default('1');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('settings');
	}
}