<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateStaffDocumentTable extends Migration {

	public function up()
	{
		Schema::create('staff_document', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('staff_id')->nullable();
			$table->text('document')->nullable();
			$table->tinyInteger('is_active')->nullable()->default('1');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('staff_document');
	}
}