<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrderTable extends Migration {

	public function up()
	{
		Schema::create('order', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('customer_id')->unsigned()->nullable();
			$table->string('ordernumber')->nullable();
			$table->double('invoice_amount');
			$table->double('invoice_amount_net');
			$table->integer('status');
			$table->integer('cleared');
			$table->string('currency', 5);
		});
	}

	public function down()
	{
		Schema::drop('order');
	}
}