<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateGiftcardTable extends Migration {

	public function up()
	{
		Schema::create('giftcard', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('billingProfileId');
			$table->string('name');
			$table->double('price');
			$table->integer('user_id')->nullable();
			$table->string('code', 6)->unique();
			$table->tinyInteger('is_active');
			$table->date('valid_till');
			$table->timestamp('created_at')->nullable();
			$table->timestamp('updated_at')->nullable();
			$table->tinyInteger('to_print');
		});
	}

	public function down()
	{
		Schema::drop('giftcard');
	}
}