<?php

namespace quizresult;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class QuizResult extends Model 
{

    protected $table = 'quiz_results';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function quiz()
    {
        return $this->hasOne('Quiz');
    }

    public function user()
    {
        return $this->hasOne('User');
    }

}