<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateGuidesQuestionsTable extends Migration {

	public function up()
	{
		Schema::create('guides_questions', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->bigInteger('guides_id')->unsigned()->nullable();
			$table->bigInteger('question_type_id')->unsigned();
			$table->bigInteger('chapter_id')->unsigned()->nullable();
			$table->string('question')->nullable();
			$table->string('answer')->nullable();
			$table->enum('present_in_textbook', array('yes', 'no'))->nullable();
			$table->integer('marks')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('guides_questions');
	}
}