<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAgentsTable extends Migration {

	public function up()
	{
		Schema::create('agents', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->string('firstName');
			$table->string('lastName');
			$table->string('matricule');
			$table->string('image');
			$table->integer('entity_id')->unsigned();
			$table->integer('qrcode_id')->unsigned();
			$table->softDeletes();
			$table->string('email');
		});
	}

	public function down()
	{
		Schema::drop('agents');
	}
}