<?php

namespace Model;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Agent extends Model 
{

    protected $table = 'agents';
    public $timestamps = false;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('firstName', 'lastName', 'matricule', 'email');

    public function qrcode()
    {
        return $this->hasOne('QrCode', 'qrcode_id');
    }

}