<?php

namespace angkasapos;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class GoodsReceipt extends Model 
{

    protected $table = 'goods_receipt';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function goodsReceiptItem()
    {
        return $this->hasMany('GoodsReceiptItems', 'id_gritem');
    }

    public function supplier()
    {
        return $this->hasOne('Suppliers', 'id_supplier');
    }

    public function tenant()
    {
        return $this->hasOne('Tenant', 'id_tenant');
    }

}