<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDebtBillingTable extends Migration {

	public function up()
	{
		Schema::create('debt_billing', function(Blueprint $table) {
			$table->increments('id_debtbill');
			$table->integer('id_tenant')->unsigned();
			$table->timestamps();
			$table->softDeletes();
			$table->integer('id_debt')->unsigned();
			$table->integer('id_customer')->unsigned();
			$table->string('billing_invoice_num', 26)->unique()->default('INV/BL/1234/08/2016/000001');
			$table->bigInteger('paid');
			$table->datetime('paid_date');
			$table->string('proof_of_payment', 100)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('debt_billing');
	}
}