<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('id_tenant')->references('id_tenant')->on('tenant')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('id_level')->references('id_level')->on('level')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('categories', function(Blueprint $table) {
			$table->foreign('id_tenant')->references('id_tenant')->on('tenant')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('suppliers', function(Blueprint $table) {
			$table->foreign('id_tenant')->references('id_tenant')->on('tenant')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('racks', function(Blueprint $table) {
			$table->foreign('id_tenant')->references('id_tenant')->on('tenant')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('goods', function(Blueprint $table) {
			$table->foreign('id_tenant')->references('id_tenant')->on('tenant')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('goods', function(Blueprint $table) {
			$table->foreign('id_units')->references('id_units')->on('units')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('goods', function(Blueprint $table) {
			$table->foreign('id_category')->references('id_goods')->on('goods')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('goods', function(Blueprint $table) {
			$table->foreign('id_supplier')->references('id_supplier')->on('suppliers')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('goods', function(Blueprint $table) {
			$table->foreign('id_rack')->references('id_rack')->on('racks')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('goods', function(Blueprint $table) {
			$table->foreign('id_stock')->references('id_stock')->on('stocks')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('stocks', function(Blueprint $table) {
			$table->foreign('id_tenant')->references('id_tenant')->on('tenant')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('stocks', function(Blueprint $table) {
			$table->foreign('id_rack')->references('id_rack')->on('racks')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('stocks', function(Blueprint $table) {
			$table->foreign('id_goods')->references('id_goods')->on('goods')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('purchase_order', function(Blueprint $table) {
			$table->foreign('id_tenant')->references('id_tenant')->on('tenant')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('purchase_order', function(Blueprint $table) {
			$table->foreign('id_supplier')->references('id_supplier')->on('suppliers')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('purchase_order', function(Blueprint $table) {
			$table->foreign('id_poitems')->references('id_poitems')->on('po_items')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('purchase_order', function(Blueprint $table) {
			$table->foreign('id_paytype')->references('id_paytype')->on('payment_types')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('po_items', function(Blueprint $table) {
			$table->foreign('id_tenant')->references('id_tenant')->on('tenant')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('po_items', function(Blueprint $table) {
			$table->foreign('id_goods')->references('id_goods')->on('goods')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('goods_receipt', function(Blueprint $table) {
			$table->foreign('id_tenant')->references('id_tenant')->on('tenant')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('goods_receipt', function(Blueprint $table) {
			$table->foreign('id_supplier')->references('id_supplier')->on('suppliers')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('goods_receipt_items', function(Blueprint $table) {
			$table->foreign('id_tenant')->references('id_tenant')->on('tenant')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('goods_receipt_items', function(Blueprint $table) {
			$table->foreign('id_goods')->references('id_goods')->on('goods')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('selling', function(Blueprint $table) {
			$table->foreign('id_tenant')->references('id_tenant')->on('tenant')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('selling', function(Blueprint $table) {
			$table->foreign('id_discount')->references('id_discount')->on('discount')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('selling', function(Blueprint $table) {
			$table->foreign('id_paytype')->references('id_paytype')->on('payment_types')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('selling_items', function(Blueprint $table) {
			$table->foreign('id_tenant')->references('id_tenant')->on('tenant')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('selling_items', function(Blueprint $table) {
			$table->foreign('id_goods')->references('id_goods')->on('goods')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('customers', function(Blueprint $table) {
			$table->foreign('id_tenant')->references('id_tenant')->on('tenant')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('discount', function(Blueprint $table) {
			$table->foreign('id_tenant')->references('id_tenant')->on('tenant')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('return_goods', function(Blueprint $table) {
			$table->foreign('id_tenant')->references('id_tenant')->on('tenant')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('return_items', function(Blueprint $table) {
			$table->foreign('id_tenant')->references('id_tenant')->on('tenant')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('return_items', function(Blueprint $table) {
			$table->foreign('id_goods')->references('id_goods')->on('goods')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('return_items', function(Blueprint $table) {
			$table->foreign('id_paytype')->references('id_paytype')->on('payment_types')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('return_items', function(Blueprint $table) {
			$table->foreign('id_supplier')->references('id_supplier')->on('suppliers')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('credits', function(Blueprint $table) {
			$table->foreign('id_tenant')->references('id_tenant')->on('tenant')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('credits', function(Blueprint $table) {
			$table->foreign('id_po')->references('id_po')->on('purchase_order')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('debts', function(Blueprint $table) {
			$table->foreign('id_tenant')->references('id_tenant')->on('tenant')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('debts', function(Blueprint $table) {
			$table->foreign('id_customer')->references('id_customer')->on('customers')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('debts', function(Blueprint $table) {
			$table->foreign('id_selling')->references('id_selling')->on('selling')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('debt_billing', function(Blueprint $table) {
			$table->foreign('id_tenant')->references('id_tenant')->on('tenant')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('debt_billing', function(Blueprint $table) {
			$table->foreign('id_debt')->references('id_debt')->on('debts')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('debt_billing', function(Blueprint $table) {
			$table->foreign('id_customer')->references('id_customer')->on('customers')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_id_tenant_foreign');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_id_level_foreign');
		});
		Schema::table('categories', function(Blueprint $table) {
			$table->dropForeign('categories_id_tenant_foreign');
		});
		Schema::table('suppliers', function(Blueprint $table) {
			$table->dropForeign('suppliers_id_tenant_foreign');
		});
		Schema::table('racks', function(Blueprint $table) {
			$table->dropForeign('racks_id_tenant_foreign');
		});
		Schema::table('goods', function(Blueprint $table) {
			$table->dropForeign('goods_id_tenant_foreign');
		});
		Schema::table('goods', function(Blueprint $table) {
			$table->dropForeign('goods_id_units_foreign');
		});
		Schema::table('goods', function(Blueprint $table) {
			$table->dropForeign('goods_id_category_foreign');
		});
		Schema::table('goods', function(Blueprint $table) {
			$table->dropForeign('goods_id_supplier_foreign');
		});
		Schema::table('goods', function(Blueprint $table) {
			$table->dropForeign('goods_id_rack_foreign');
		});
		Schema::table('goods', function(Blueprint $table) {
			$table->dropForeign('goods_id_stock_foreign');
		});
		Schema::table('stocks', function(Blueprint $table) {
			$table->dropForeign('stocks_id_tenant_foreign');
		});
		Schema::table('stocks', function(Blueprint $table) {
			$table->dropForeign('stocks_id_rack_foreign');
		});
		Schema::table('stocks', function(Blueprint $table) {
			$table->dropForeign('stocks_id_goods_foreign');
		});
		Schema::table('purchase_order', function(Blueprint $table) {
			$table->dropForeign('purchase_order_id_tenant_foreign');
		});
		Schema::table('purchase_order', function(Blueprint $table) {
			$table->dropForeign('purchase_order_id_supplier_foreign');
		});
		Schema::table('purchase_order', function(Blueprint $table) {
			$table->dropForeign('purchase_order_id_poitems_foreign');
		});
		Schema::table('purchase_order', function(Blueprint $table) {
			$table->dropForeign('purchase_order_id_paytype_foreign');
		});
		Schema::table('po_items', function(Blueprint $table) {
			$table->dropForeign('po_items_id_tenant_foreign');
		});
		Schema::table('po_items', function(Blueprint $table) {
			$table->dropForeign('po_items_id_goods_foreign');
		});
		Schema::table('goods_receipt', function(Blueprint $table) {
			$table->dropForeign('goods_receipt_id_tenant_foreign');
		});
		Schema::table('goods_receipt', function(Blueprint $table) {
			$table->dropForeign('goods_receipt_id_supplier_foreign');
		});
		Schema::table('goods_receipt_items', function(Blueprint $table) {
			$table->dropForeign('goods_receipt_items_id_tenant_foreign');
		});
		Schema::table('goods_receipt_items', function(Blueprint $table) {
			$table->dropForeign('goods_receipt_items_id_goods_foreign');
		});
		Schema::table('selling', function(Blueprint $table) {
			$table->dropForeign('selling_id_tenant_foreign');
		});
		Schema::table('selling', function(Blueprint $table) {
			$table->dropForeign('selling_id_discount_foreign');
		});
		Schema::table('selling', function(Blueprint $table) {
			$table->dropForeign('selling_id_paytype_foreign');
		});
		Schema::table('selling_items', function(Blueprint $table) {
			$table->dropForeign('selling_items_id_tenant_foreign');
		});
		Schema::table('selling_items', function(Blueprint $table) {
			$table->dropForeign('selling_items_id_goods_foreign');
		});
		Schema::table('customers', function(Blueprint $table) {
			$table->dropForeign('customers_id_tenant_foreign');
		});
		Schema::table('discount', function(Blueprint $table) {
			$table->dropForeign('discount_id_tenant_foreign');
		});
		Schema::table('return_goods', function(Blueprint $table) {
			$table->dropForeign('return_goods_id_tenant_foreign');
		});
		Schema::table('return_items', function(Blueprint $table) {
			$table->dropForeign('return_items_id_tenant_foreign');
		});
		Schema::table('return_items', function(Blueprint $table) {
			$table->dropForeign('return_items_id_goods_foreign');
		});
		Schema::table('return_items', function(Blueprint $table) {
			$table->dropForeign('return_items_id_paytype_foreign');
		});
		Schema::table('return_items', function(Blueprint $table) {
			$table->dropForeign('return_items_id_supplier_foreign');
		});
		Schema::table('credits', function(Blueprint $table) {
			$table->dropForeign('credits_id_tenant_foreign');
		});
		Schema::table('credits', function(Blueprint $table) {
			$table->dropForeign('credits_id_po_foreign');
		});
		Schema::table('debts', function(Blueprint $table) {
			$table->dropForeign('debts_id_tenant_foreign');
		});
		Schema::table('debts', function(Blueprint $table) {
			$table->dropForeign('debts_id_customer_foreign');
		});
		Schema::table('debts', function(Blueprint $table) {
			$table->dropForeign('debts_id_selling_foreign');
		});
		Schema::table('debt_billing', function(Blueprint $table) {
			$table->dropForeign('debt_billing_id_tenant_foreign');
		});
		Schema::table('debt_billing', function(Blueprint $table) {
			$table->dropForeign('debt_billing_id_debt_foreign');
		});
		Schema::table('debt_billing', function(Blueprint $table) {
			$table->dropForeign('debt_billing_id_customer_foreign');
		});
	}
}