<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSurveyQuestionsTable extends Migration {

	public function up()
	{
		Schema::create('survey_questions', function(Blueprint $table) {
			$table->increments('id');
			$table->uuid('uuid');
			$table->integer('survey_id');
			$table->integer('client_id');
			$table->string('question_type');
			$table->integer('author_id');
			$table->string('title');
			$table->text('description');
			$table->boolean('required')->default(1);
			$table->integer('order');
			$table->string('data_type', 100)->nullable();
			$table->integer('data_id')->nullable();
			$table->string('status', 20);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('survey_questions');
	}
}