<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Player extends Model 
{

    protected $table = 'players';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function player_owner()
    {
        return $this->hasMany('Player_owners', 'player_id');
    }

    public function player_register()
    {
        return $this->hasMany('Course_player_register', 'player_id');
    }

    public function testing()
    {
        return $this->hasMany('Player_testing', 'player_id');
    }

}