<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function player_owner()
	{
		return $this->hasMany('Player_owners', 'user_id');
	}

	public function coach_register()
	{
		return $this->hasMany('Course_coach_register', 'user_id');
	}

}