<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('institutions', function(Blueprint $table) {
			$table->foreign('type_id')->references('id')->on('institutiontypes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('comptes', function(Blueprint $table) {
			$table->foreign('typecompte_id')->references('id')->on('comptetypes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('comptes', function(Blueprint $table) {
			$table->foreign('institution_id')->references('id')->on('institutions')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('comptes', function(Blueprint $table) {
			$table->foreign('fournisseur_id')->references('id')->on('fournisseurs')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('transactions', function(Blueprint $table) {
			$table->foreign('classe_id')->references('id')->on('regrouptrans')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('transactions', function(Blueprint $table) {
			$table->foreign('fournisseur_id')->references('id')->on('fournisseurs')
						->onDelete('restrict')
						->onUpdate('no action');
		});
		Schema::table('transactions', function(Blueprint $table) {
			$table->foreign('projet_id')->references('id')->on('projets')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('transactions', function(Blueprint $table) {
			$table->foreign('compte_id')->references('id')->on('comptes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('transactions', function(Blueprint $table) {
			$table->foreign('regrouptrans_id')->references('id')->on('regrouptrans')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('transactions', function(Blueprint $table) {
			$table->foreign('regroupcategorie_id')->references('id')->on('regroupcategories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('transactions', function(Blueprint $table) {
			$table->foreign('transcategorie_id')->references('id')->on('regroupcategories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('regroupcategories', function(Blueprint $table) {
			$table->foreign('regrouptrans_id')->references('id')->on('regrouptrans')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('budgets', function(Blueprint $table) {
			$table->foreign('compte_id')->references('id')->on('comptes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('budgets', function(Blueprint $table) {
			$table->foreign('regrouptrans_id')->references('id')->on('regrouptrans')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('institutions', function(Blueprint $table) {
			$table->dropForeign('institutions_type_id_foreign');
		});
		Schema::table('comptes', function(Blueprint $table) {
			$table->dropForeign('comptes_typecompte_id_foreign');
		});
		Schema::table('comptes', function(Blueprint $table) {
			$table->dropForeign('comptes_institution_id_foreign');
		});
		Schema::table('comptes', function(Blueprint $table) {
			$table->dropForeign('comptes_fournisseur_id_foreign');
		});
		Schema::table('transactions', function(Blueprint $table) {
			$table->dropForeign('transactions_classe_id_foreign');
		});
		Schema::table('transactions', function(Blueprint $table) {
			$table->dropForeign('transactions_fournisseur_id_foreign');
		});
		Schema::table('transactions', function(Blueprint $table) {
			$table->dropForeign('transactions_projet_id_foreign');
		});
		Schema::table('transactions', function(Blueprint $table) {
			$table->dropForeign('transactions_compte_id_foreign');
		});
		Schema::table('transactions', function(Blueprint $table) {
			$table->dropForeign('transactions_regrouptrans_id_foreign');
		});
		Schema::table('transactions', function(Blueprint $table) {
			$table->dropForeign('transactions_regroupcategorie_id_foreign');
		});
		Schema::table('transactions', function(Blueprint $table) {
			$table->dropForeign('transactions_transcategorie_id_foreign');
		});
		Schema::table('regroupcategories', function(Blueprint $table) {
			$table->dropForeign('regroupcategories_regrouptrans_id_foreign');
		});
		Schema::table('budgets', function(Blueprint $table) {
			$table->dropForeign('budgets_compte_id_foreign');
		});
		Schema::table('budgets', function(Blueprint $table) {
			$table->dropForeign('budgets_regrouptrans_id_foreign');
		});
	}
}