<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('nationality_id')->references('id')->on('countries')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('language_id')->references('id')->on('languages')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('rides', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('rides', function(Blueprint $table) {
			$table->foreign('vehicle_id')->references('id')->on('vehicles')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('ride_stopovers', function(Blueprint $table) {
			$table->foreign('ride_id')->references('id')->on('rides')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('ride_requests', function(Blueprint $table) {
			$table->foreign('ride_id')->references('id')->on('rides')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('ride_requests', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('ride_requests', function(Blueprint $table) {
			$table->foreign('status_id')->references('id')->on('statuses')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('ride_requests', function(Blueprint $table) {
			$table->foreign('payment_method_id')->references('id')->on('payment_methods')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_reports', function(Blueprint $table) {
			$table->foreign('reporter_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('user_reports', function(Blueprint $table) {
			$table->foreign('reported_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('user_reports', function(Blueprint $table) {
			$table->foreign('ride_id')->references('id')->on('rides')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('ride_reviews', function(Blueprint $table) {
			$table->foreign('ride_id')->references('id')->on('rides')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('ride_reviews', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('vehicles', function(Blueprint $table) {
			$table->foreign('vehicle_model_id')->references('id')->on('vehicle_models')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('vehicles', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('vehicles', function(Blueprint $table) {
			$table->foreign('vehicle_type_id')->references('id')->on('vehicle_types')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('saved_places', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('saved_places', function(Blueprint $table) {
			$table->foreign('type_id')->references('id')->on('types')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('otps', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('user_verifications', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('wallets', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('wallet_transactions', function(Blueprint $table) {
			$table->foreign('wallet_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('wallet_transactions', function(Blueprint $table) {
			$table->foreign('ride_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('wallet_transactions', function(Blueprint $table) {
			$table->foreign('status_id')->references('id')->on('statuses')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('wallet_transactions', function(Blueprint $table) {
			$table->foreign('type_id')->references('id')->on('types')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('vehicle_verification', function(Blueprint $table) {
			$table->foreign('vehicle_id')->references('id')->on('vehicles')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('admins', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('admins', function(Blueprint $table) {
			$table->foreign('language_id')->references('id')->on('languages')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('safes', function(Blueprint $table) {
			$table->foreign('admin_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('safe_transactions', function(Blueprint $table) {
			$table->foreign('safe_id')->references('id')->on('safes')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('safe_transactions', function(Blueprint $table) {
			$table->foreign('bank_account_id')->references('id')->on('bank_accounts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('bank_accounts', function(Blueprint $table) {
			$table->foreign('admin_id')->references('id')->on('admins')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('ride_request_payment_transactions', function(Blueprint $table) {
			$table->foreign('ride_request_id')->references('id')->on('ride_requests')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('ride_request_payment_transactions', function(Blueprint $table) {
			$table->foreign('payment_gateway_id')->references('id')->on('payment_gateways')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('status_locales', function(Blueprint $table) {
			$table->foreign('status_id')->references('id')->on('statuses')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('status_locales', function(Blueprint $table) {
			$table->foreign('language_id')->references('id')->on('languages')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('type_locales', function(Blueprint $table) {
			$table->foreign('type_id')->references('id')->on('types')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('type_locales', function(Blueprint $table) {
			$table->foreign('language_id')->references('id')->on('languages')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_nationality_id_foreign');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_language_id_foreign');
		});
		Schema::table('rides', function(Blueprint $table) {
			$table->dropForeign('rides_user_id_foreign');
		});
		Schema::table('rides', function(Blueprint $table) {
			$table->dropForeign('rides_vehicle_id_foreign');
		});
		Schema::table('ride_stopovers', function(Blueprint $table) {
			$table->dropForeign('ride_stopovers_ride_id_foreign');
		});
		Schema::table('ride_requests', function(Blueprint $table) {
			$table->dropForeign('ride_requests_ride_id_foreign');
		});
		Schema::table('ride_requests', function(Blueprint $table) {
			$table->dropForeign('ride_requests_user_id_foreign');
		});
		Schema::table('ride_requests', function(Blueprint $table) {
			$table->dropForeign('ride_requests_status_id_foreign');
		});
		Schema::table('ride_requests', function(Blueprint $table) {
			$table->dropForeign('ride_requests_payment_method_id_foreign');
		});
		Schema::table('user_reports', function(Blueprint $table) {
			$table->dropForeign('user_reports_reporter_id_foreign');
		});
		Schema::table('user_reports', function(Blueprint $table) {
			$table->dropForeign('user_reports_reported_id_foreign');
		});
		Schema::table('user_reports', function(Blueprint $table) {
			$table->dropForeign('user_reports_ride_id_foreign');
		});
		Schema::table('ride_reviews', function(Blueprint $table) {
			$table->dropForeign('ride_reviews_ride_id_foreign');
		});
		Schema::table('ride_reviews', function(Blueprint $table) {
			$table->dropForeign('ride_reviews_user_id_foreign');
		});
		Schema::table('vehicles', function(Blueprint $table) {
			$table->dropForeign('vehicles_vehicle_model_id_foreign');
		});
		Schema::table('vehicles', function(Blueprint $table) {
			$table->dropForeign('vehicles_user_id_foreign');
		});
		Schema::table('vehicles', function(Blueprint $table) {
			$table->dropForeign('vehicles_vehicle_type_id_foreign');
		});
		Schema::table('saved_places', function(Blueprint $table) {
			$table->dropForeign('saved_places_user_id_foreign');
		});
		Schema::table('saved_places', function(Blueprint $table) {
			$table->dropForeign('saved_places_type_id_foreign');
		});
		Schema::table('otps', function(Blueprint $table) {
			$table->dropForeign('otps_user_id_foreign');
		});
		Schema::table('user_verifications', function(Blueprint $table) {
			$table->dropForeign('user_verifications_user_id_foreign');
		});
		Schema::table('wallets', function(Blueprint $table) {
			$table->dropForeign('wallets_user_id_foreign');
		});
		Schema::table('wallet_transactions', function(Blueprint $table) {
			$table->dropForeign('wallet_transactions_wallet_id_foreign');
		});
		Schema::table('wallet_transactions', function(Blueprint $table) {
			$table->dropForeign('wallet_transactions_ride_id_foreign');
		});
		Schema::table('wallet_transactions', function(Blueprint $table) {
			$table->dropForeign('wallet_transactions_status_id_foreign');
		});
		Schema::table('wallet_transactions', function(Blueprint $table) {
			$table->dropForeign('wallet_transactions_type_id_foreign');
		});
		Schema::table('vehicle_verification', function(Blueprint $table) {
			$table->dropForeign('vehicle_verification_vehicle_id_foreign');
		});
		Schema::table('admins', function(Blueprint $table) {
			$table->dropForeign('admins_country_id_foreign');
		});
		Schema::table('admins', function(Blueprint $table) {
			$table->dropForeign('admins_language_id_foreign');
		});
		Schema::table('safes', function(Blueprint $table) {
			$table->dropForeign('safes_admin_id_foreign');
		});
		Schema::table('safe_transactions', function(Blueprint $table) {
			$table->dropForeign('safe_transactions_safe_id_foreign');
		});
		Schema::table('safe_transactions', function(Blueprint $table) {
			$table->dropForeign('safe_transactions_bank_account_id_foreign');
		});
		Schema::table('bank_accounts', function(Blueprint $table) {
			$table->dropForeign('bank_accounts_admin_id_foreign');
		});
		Schema::table('ride_request_payment_transactions', function(Blueprint $table) {
			$table->dropForeign('ride_request_payment_transactions_ride_request_id_foreign');
		});
		Schema::table('ride_request_payment_transactions', function(Blueprint $table) {
			$table->dropForeign('ride_request_payment_transactions_payment_gateway_id_foreign');
		});
		Schema::table('status_locales', function(Blueprint $table) {
			$table->dropForeign('status_locales_status_id_foreign');
		});
		Schema::table('status_locales', function(Blueprint $table) {
			$table->dropForeign('status_locales_language_id_foreign');
		});
		Schema::table('type_locales', function(Blueprint $table) {
			$table->dropForeign('type_locales_type_id_foreign');
		});
		Schema::table('type_locales', function(Blueprint $table) {
			$table->dropForeign('type_locales_language_id_foreign');
		});
	}
}