<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('full_name', 'email', 'phone', 'is_smoking', 'active', 'latitude', 'longitude');

	public function rides()
	{
		return $this->hasMany('Ride');
	}

	public function wallet()
	{
		return $this->hasOne('Wallet');
	}

}