<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductsTable extends Migration {

	public function up()
	{
		Schema::create('products', function(Blueprint $table) {
			$table->increments('id');
			$table->string('title', 255);
			$table->text('description');
			$table->integer('brand_id')->unsigned();
			$table->integer('collection_id')->unsigned();
			$table->integer('category_id')->unsigned();
			$table->boolean('sale');
			$table->integer('discount');
			$table->enum('discount_type', array('fixed', 'percentage'));
			$table->boolean('new');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('products');
	}
}