<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('beer', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('category')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('order', function(Blueprint $table) {
			$table->foreign('waiter_id')->references('id')->on('waiter')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('order_beer', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('order')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('order_beer', function(Blueprint $table) {
			$table->foreign('beer_id')->references('id')->on('beer')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('stock', function(Blueprint $table) {
			$table->foreign('beer_id')->references('id')->on('beer')
						->onDelete('no action')
						->onUpdate('no action');
		});
	}

	public function down()
	{
		Schema::table('beer', function(Blueprint $table) {
			$table->dropForeign('beer_category_id_foreign');
		});
		Schema::table('order', function(Blueprint $table) {
			$table->dropForeign('order_waiter_id_foreign');
		});
		Schema::table('order_beer', function(Blueprint $table) {
			$table->dropForeign('order_beer_order_id_foreign');
		});
		Schema::table('order_beer', function(Blueprint $table) {
			$table->dropForeign('order_beer_beer_id_foreign');
		});
		Schema::table('stock', function(Blueprint $table) {
			$table->dropForeign('stock_beer_id_foreign');
		});
	}
}