<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePromotionsTable extends Migration {

	public function up()
	{
		Schema::create('promotions', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name', 250)->nullable()->index();
			$table->timestamp('date_start')->nullable()->index();
			$table->timestamp('date_end')->nullable()->index();
			$table->text('description')->nullable();
			$table->decimal('rate', 8,2)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('promotions');
	}
}