<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOffersTable extends Migration {

	public function up()
	{
		Schema::create('offers', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->timestamp('start_date');
			$table->timestamp('end_date');
			$table->bigInteger('category_id')->unsigned();
			$table->text('description');
			$table->decimal('discount_ratio');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('offers');
	}
}