<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class PhysicalExamOverride extends Model 
{

    protected $table = 'physical_exam_overrides';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function clinical_sign()
    {
        return $this->belongsTo('ClinicalSign');
    }

    public function exams()
    {
        return $this->hasMany('Exam');
    }

}