<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateScenariosTable extends Migration {

	public function up()
	{
		Schema::create('scenarios', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('title', 256);
			$table->text('intro_text');
			$table->string('objectif', 256);
			$table->string('scenario_icon', 256);
			$table->integer('practitioner_index');
			$table->datetime('date');
			$table->bigInteger('allotted_time');
			$table->bigInteger('patient_id');
			$table->bigInteger('environment_id');
			$table->bigInteger('scenario_to_play_id');
			$table->json('json');
		});
	}

	public function down()
	{
		Schema::drop('scenarios');
	}
}