<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePatientBackgroundsTable extends Migration {

	public function up()
	{
		Schema::create('patient_backgrounds', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->bigInteger('antecedent_id');
			$table->bigInteger('patient_id');
			$table->integer('affected_person_index');
			$table->integer('age');
			$table->boolean('severity');
			$table->text('particularity');
		});
	}

	public function down()
	{
		Schema::drop('patient_backgrounds');
	}
}