<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('personal_folder', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('files', function(Blueprint $table) {
			$table->foreign('file_type_id')->references('id')->on('file_types')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('files', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('files', function(Blueprint $table) {
			$table->foreign('service_profile_id')->references('id')->on('service_profiles')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('profile_fields', function(Blueprint $table) {
			$table->foreign('profile_type_id')->references('id')->on('profile_types')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('service_types', function(Blueprint $table) {
			$table->foreign('profile_type_id')->references('id')->on('profile_types')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('service_type_profile_fields', function(Blueprint $table) {
			$table->foreign('service_type_id')->references('id')->on('service_types')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('service_type_profile_fields', function(Blueprint $table) {
			$table->foreign('profile_field_id')->references('id')->on('profile_fields')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('service_type_file_types', function(Blueprint $table) {
			$table->foreign('service_type_id')->references('id')->on('service_types')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('service_type_file_types', function(Blueprint $table) {
			$table->foreign('file_type_id')->references('id')->on('file_types')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('user_profile', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('user_profile', function(Blueprint $table) {
			$table->foreign('profile_type_id')->references('id')->on('profile_types')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('user_profile_data', function(Blueprint $table) {
			$table->foreign('user_profile_id')->references('id')->on('user_profile')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('user_profile_data', function(Blueprint $table) {
			$table->foreign('profile_field_id')->references('id')->on('profile_fields')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('personal_folder_files', function(Blueprint $table) {
			$table->foreign('file_id')->references('id')->on('files')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('personal_folder_files', function(Blueprint $table) {
			$table->foreign('personal_folder_id')->references('id')->on('personal_folder')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('file_shares', function(Blueprint $table) {
			$table->foreign('file_id')->references('id')->on('files')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('file_shares', function(Blueprint $table) {
			$table->foreign('shared_with_user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('file_shares', function(Blueprint $table) {
			$table->foreign('shared_with_lead_id')->references('id')->on('leads')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('file_shares', function(Blueprint $table) {
			$table->foreign('shared_with_active_service_id')->references('id')->on('active_service')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('file_shares', function(Blueprint $table) {
			$table->foreign('file_request_id')->references('id')->on('file_requests')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('file_reminders', function(Blueprint $table) {
			$table->foreign('file_id')->references('id')->on('files')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('file_reminders', function(Blueprint $table) {
			$table->foreign('service_profile_id')->references('id')->on('service_profiles')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('quotes', function(Blueprint $table) {
			$table->foreign('user_profile_id')->references('id')->on('user_profile')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('quotes', function(Blueprint $table) {
			$table->foreign('service_type_id')->references('id')->on('service_types')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('quotes', function(Blueprint $table) {
			$table->foreign('current_active_service_id')->references('id')->on('active_service')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('leads', function(Blueprint $table) {
			$table->foreign('quote_id')->references('id')->on('quotes')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('leads', function(Blueprint $table) {
			$table->foreign('service_profile_id')->references('id')->on('service_profiles')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('notifications', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('notifications', function(Blueprint $table) {
			$table->foreign('service_profile_id')->references('id')->on('service_profiles')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('business_profiles', function(Blueprint $table) {
			$table->foreign('administrator_user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('service_profiles', function(Blueprint $table) {
			$table->foreign('business_profile_id')->references('id')->on('business_profiles')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('service_profiles', function(Blueprint $table) {
			$table->foreign('service_type_id')->references('id')->on('service_types')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('clients', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('clients', function(Blueprint $table) {
			$table->foreign('service_profile_id')->references('id')->on('service_profiles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('client_invitations', function(Blueprint $table) {
			$table->foreign('service_profile_id')->references('id')->on('service_profiles')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('client_invitations', function(Blueprint $table) {
			$table->foreign('existing_user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('client_invitations', function(Blueprint $table) {
			$table->foreign('created_active_service_id')->references('id')->on('active_service')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('active_service', function(Blueprint $table) {
			$table->foreign('client_id')->references('id')->on('clients')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('active_service', function(Blueprint $table) {
			$table->foreign('client_user_profile_id')->references('id')->on('user_profile')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('active_service', function(Blueprint $table) {
			$table->foreign('approved_lead_id')->references('id')->on('leads')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('service_profile_area', function(Blueprint $table) {
			$table->foreign('service_profile_id')->references('id')->on('service_profiles')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('service_profile_area', function(Blueprint $table) {
			$table->foreign('subscription_id')->references('id')->on('subscriptions')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('service_admins', function(Blueprint $table) {
			$table->foreign('service_profile_id')->references('id')->on('service_profiles')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('service_admins', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('file_requests', function(Blueprint $table) {
			$table->foreign('lead_id')->references('id')->on('leads')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('file_requests', function(Blueprint $table) {
			$table->foreign('active_service_id')->references('id')->on('active_service')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('billing_details', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('billing_details', function(Blueprint $table) {
			$table->foreign('business_profile_id')->references('id')->on('business_profiles')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('subscriptions', function(Blueprint $table) {
			$table->foreign('billing_details_id')->references('id')->on('billing_details')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('bills', function(Blueprint $table) {
			$table->foreign('billing_details_id')->references('id')->on('billing_details')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('bills', function(Blueprint $table) {
			$table->foreign('subscription_id')->references('id')->on('subscriptions')
						->onDelete('set null')
						->onUpdate('set null');
		});
	}

	public function down()
	{
		Schema::table('personal_folder', function(Blueprint $table) {
			$table->dropForeign('personal_folder_user_id_foreign');
		});
		Schema::table('files', function(Blueprint $table) {
			$table->dropForeign('files_file_type_id_foreign');
		});
		Schema::table('files', function(Blueprint $table) {
			$table->dropForeign('files_user_id_foreign');
		});
		Schema::table('files', function(Blueprint $table) {
			$table->dropForeign('files_service_profile_id_foreign');
		});
		Schema::table('profile_fields', function(Blueprint $table) {
			$table->dropForeign('profile_fields_profile_type_id_foreign');
		});
		Schema::table('service_types', function(Blueprint $table) {
			$table->dropForeign('service_types_profile_type_id_foreign');
		});
		Schema::table('service_type_profile_fields', function(Blueprint $table) {
			$table->dropForeign('service_type_profile_fields_service_type_id_foreign');
		});
		Schema::table('service_type_profile_fields', function(Blueprint $table) {
			$table->dropForeign('service_type_profile_fields_profile_field_id_foreign');
		});
		Schema::table('service_type_file_types', function(Blueprint $table) {
			$table->dropForeign('service_type_file_types_service_type_id_foreign');
		});
		Schema::table('service_type_file_types', function(Blueprint $table) {
			$table->dropForeign('service_type_file_types_file_type_id_foreign');
		});
		Schema::table('user_profile', function(Blueprint $table) {
			$table->dropForeign('user_profile_user_id_foreign');
		});
		Schema::table('user_profile', function(Blueprint $table) {
			$table->dropForeign('user_profile_profile_type_id_foreign');
		});
		Schema::table('user_profile_data', function(Blueprint $table) {
			$table->dropForeign('user_profile_data_user_profile_id_foreign');
		});
		Schema::table('user_profile_data', function(Blueprint $table) {
			$table->dropForeign('user_profile_data_profile_field_id_foreign');
		});
		Schema::table('personal_folder_files', function(Blueprint $table) {
			$table->dropForeign('personal_folder_files_file_id_foreign');
		});
		Schema::table('personal_folder_files', function(Blueprint $table) {
			$table->dropForeign('personal_folder_files_personal_folder_id_foreign');
		});
		Schema::table('file_shares', function(Blueprint $table) {
			$table->dropForeign('file_shares_file_id_foreign');
		});
		Schema::table('file_shares', function(Blueprint $table) {
			$table->dropForeign('file_shares_shared_with_user_id_foreign');
		});
		Schema::table('file_shares', function(Blueprint $table) {
			$table->dropForeign('file_shares_shared_with_lead_id_foreign');
		});
		Schema::table('file_shares', function(Blueprint $table) {
			$table->dropForeign('file_shares_shared_with_active_service_id_foreign');
		});
		Schema::table('file_shares', function(Blueprint $table) {
			$table->dropForeign('file_shares_file_request_id_foreign');
		});
		Schema::table('file_reminders', function(Blueprint $table) {
			$table->dropForeign('file_reminders_file_id_foreign');
		});
		Schema::table('file_reminders', function(Blueprint $table) {
			$table->dropForeign('file_reminders_service_profile_id_foreign');
		});
		Schema::table('quotes', function(Blueprint $table) {
			$table->dropForeign('quotes_user_profile_id_foreign');
		});
		Schema::table('quotes', function(Blueprint $table) {
			$table->dropForeign('quotes_service_type_id_foreign');
		});
		Schema::table('quotes', function(Blueprint $table) {
			$table->dropForeign('quotes_current_active_service_id_foreign');
		});
		Schema::table('leads', function(Blueprint $table) {
			$table->dropForeign('leads_quote_id_foreign');
		});
		Schema::table('leads', function(Blueprint $table) {
			$table->dropForeign('leads_service_profile_id_foreign');
		});
		Schema::table('notifications', function(Blueprint $table) {
			$table->dropForeign('notifications_user_id_foreign');
		});
		Schema::table('notifications', function(Blueprint $table) {
			$table->dropForeign('notifications_service_profile_id_foreign');
		});
		Schema::table('business_profiles', function(Blueprint $table) {
			$table->dropForeign('business_profiles_administrator_user_id_foreign');
		});
		Schema::table('service_profiles', function(Blueprint $table) {
			$table->dropForeign('service_profiles_business_profile_id_foreign');
		});
		Schema::table('service_profiles', function(Blueprint $table) {
			$table->dropForeign('service_profiles_service_type_id_foreign');
		});
		Schema::table('clients', function(Blueprint $table) {
			$table->dropForeign('clients_user_id_foreign');
		});
		Schema::table('clients', function(Blueprint $table) {
			$table->dropForeign('clients_service_profile_id_foreign');
		});
		Schema::table('client_invitations', function(Blueprint $table) {
			$table->dropForeign('client_invitations_service_profile_id_foreign');
		});
		Schema::table('client_invitations', function(Blueprint $table) {
			$table->dropForeign('client_invitations_existing_user_id_foreign');
		});
		Schema::table('client_invitations', function(Blueprint $table) {
			$table->dropForeign('client_invitations_created_active_service_id_foreign');
		});
		Schema::table('active_service', function(Blueprint $table) {
			$table->dropForeign('active_service_client_id_foreign');
		});
		Schema::table('active_service', function(Blueprint $table) {
			$table->dropForeign('active_service_client_user_profile_id_foreign');
		});
		Schema::table('active_service', function(Blueprint $table) {
			$table->dropForeign('active_service_approved_lead_id_foreign');
		});
		Schema::table('service_profile_area', function(Blueprint $table) {
			$table->dropForeign('service_profile_area_service_profile_id_foreign');
		});
		Schema::table('service_profile_area', function(Blueprint $table) {
			$table->dropForeign('service_profile_area_subscription_id_foreign');
		});
		Schema::table('service_admins', function(Blueprint $table) {
			$table->dropForeign('service_admins_service_profile_id_foreign');
		});
		Schema::table('service_admins', function(Blueprint $table) {
			$table->dropForeign('service_admins_user_id_foreign');
		});
		Schema::table('file_requests', function(Blueprint $table) {
			$table->dropForeign('file_requests_lead_id_foreign');
		});
		Schema::table('file_requests', function(Blueprint $table) {
			$table->dropForeign('file_requests_active_service_id_foreign');
		});
		Schema::table('billing_details', function(Blueprint $table) {
			$table->dropForeign('billing_details_user_id_foreign');
		});
		Schema::table('billing_details', function(Blueprint $table) {
			$table->dropForeign('billing_details_business_profile_id_foreign');
		});
		Schema::table('subscriptions', function(Blueprint $table) {
			$table->dropForeign('subscriptions_billing_details_id_foreign');
		});
		Schema::table('bills', function(Blueprint $table) {
			$table->dropForeign('bills_billing_details_id_foreign');
		});
		Schema::table('bills', function(Blueprint $table) {
			$table->dropForeign('bills_subscription_id_foreign');
		});
	}
}