<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateColumnTypesTable extends Migration {

	public function up()
	{
		Schema::create('column_types', function(Blueprint $table) {
			$table->increments('id');
			$table->string('type', 25);
			$table->string('description')->nullable();
			$table->string('name', 50)->nullable();
			$table->string('icon_path');
			$table->smallInteger('width')->unsigned();
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('column_types');
	}
}